<?php
require_once __DIR__."/../config/db.php";
$id = intval($_GET['id'] ?? 0);
$stmt=$pdo->prepare("SELECT * FROM foods WHERE id=?");
$stmt->execute([$id]);
$f=$stmt->fetch(PDO::FETCH_ASSOC);
if(!$f) die("Not found");
?>
<!doctype html>
<html lang="ru">
<head>
  <meta charset="utf-8">
  <title><?=htmlspecialchars($f['name'])?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="container">
  <a class="muted" href="index.php">← назад</a>
  <div class="card" style="margin-top:10px">
    <img style="height:220px" src="<?=htmlspecialchars($f['image_url'] ?: '/assets/img/placeholder.jpg')?>">
    <div class="card-body">
      <div class="card-title" style="font-size:20px"><?=htmlspecialchars($f['name'])?></div>
      <div class="price"><?=intval($f['price'])?> ₸</div>
      <?php if($f['description']): ?>
        <div class="muted"><?=nl2br(htmlspecialchars($f['description']))?></div>
      <?php endif; ?>

      <div class="notice">
        <b>Состав:</b><br>
        <?=nl2br(htmlspecialchars($f['ingredients'] ?: 'Состав уточняйте у персонала.'))?>
      </div>

      <?php if($f['is_available']): ?>
        <button class="btn btn-accent" id="add">Добавить в корзину</button>
      <?php else: ?>
        <div class="muted">Позиция временно на стопе</div>
      <?php endif; ?>
    </div>
  </div>
</div>

<a class="cart-fab" href="cart.php">Корзина (0)</a>

<script src="/assets/js/app.js"></script>
<script>
<?php if($f['is_available']): ?>
document.getElementById("add").onclick=()=>{
  addToCart({id:<?=$f['id']?>,name:<?=json_encode($f['name'])?>,price:<?=$f['price']?>});
};
<?php endif; ?>
</script>
</body>
</html>
