<?php
require_once __DIR__."/../../config/db.php";
header("Content-Type: application/json");

$input = json_decode(file_get_contents("php://input"), true);
$pc = trim($input['pc_number'] ?? "");
$hall = trim($input['hall_name'] ?? "");
$comment = trim($input['comment'] ?? "");
$items = $input['items'] ?? [];

if(!$pc || !is_array($items) || count($items)==0){
  echo json_encode(["ok"=>false,"error"=>"Bad request"]); exit;
}

$subtotal=0;
foreach($items as $it){
  $subtotal += intval($it['price']) * intval($it['qty']);
}
$service_fee = (int)round($subtotal*0.10);
$total = $subtotal + $service_fee;

$pdo->beginTransaction();
try{
  $st=$pdo->prepare("INSERT INTO orders(pc_number,hall_name,subtotal,service_fee,total,comment) VALUES(?,?,?,?,?,?)");
  $st->execute([$pc,$hall,$subtotal,$service_fee,$total,$comment]);
  $order_id = $pdo->lastInsertId();

  $sti=$pdo->prepare("INSERT INTO order_items(order_id,food_id,food_name,quantity,price) VALUES(?,?,?,?,?)");
  foreach($items as $it){
    $sti->execute([
      $order_id,
      intval($it['id']),
      $it['name'],
      intval($it['qty']),
      intval($it['price'])
    ]);
  }

  $pdo->commit();
  echo json_encode(["ok"=>true,"order_id"=>$order_id], JSON_UNESCAPED_UNICODE);

}catch(Exception $e){
  $pdo->rollBack();
  echo json_encode(["ok"=>false,"error"=>$e->getMessage()]);
}
