const CART_KEY = "triumph_cart_v1";

function getCart(){
  try { return JSON.parse(localStorage.getItem(CART_KEY)) || []; }
  catch(e){ return []; }
}
function saveCart(c){ localStorage.setItem(CART_KEY, JSON.stringify(c)); updateCartFab(); }

function addToCart(item){
  const c = getCart();
  const found = c.find(x=>x.id==item.id);
  if(found) found.qty++;
  else c.push({...item, qty:1});
  saveCart(c);
}

function setQty(id, qty){
  let c = getCart();
  c = c.map(x=> x.id==id ? {...x, qty:Math.max(0,qty)} : x).filter(x=>x.qty>0);
  saveCart(c);
}

function updateCartFab(){
  const c = getCart();
  const count = c.reduce((s,x)=>s+x.qty,0);
  const fab = document.querySelector(".cart-fab");
  if(fab) fab.innerText = `Корзина (${count})`;
}

document.addEventListener("DOMContentLoaded", updateCartFab);
