<?php
require_once __DIR__."/../config/db.php";
require_once __DIR__."/../config/auth.php";
require_login();
$role=$_SESSION['user']['role'];

$cats=$pdo->query("SELECT * FROM categories ORDER BY sort_order,id")->fetchAll(PDO::FETCH_ASSOC);
$foods=$pdo->query("
  SELECT f.*, c.name as cat_name
  FROM foods f JOIN categories c ON c.id=f.category_id
  ORDER BY f.id DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="ru">
<head>
  <meta charset="utf-8">
  <title>Меню • Triumph</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="container">
  <div class="header">
    <div class="logo">Triumph • Меню</div>
    <div class="row">
      <a class="btn btn-ghost" href="dashboard.php">Заказы</a>
      <?php if($role==='owner'): ?>
        <a class="btn btn-ghost" href="categories.php">Категории</a>
      <?php endif; ?>
      <a class="btn btn-ghost" href="logout.php">Выйти</a>
    </div>
  </div>

  <?php if($role==='owner'): ?>
  <h3>Добавить блюдо</h3>
  <form class="notice" method="post" action="api/foods_crud.php" enctype="multipart/form-data">
    <input type="hidden" name="action" value="create">
    <label>Категория</label>
    <select name="category_id" required>
      <?php foreach($cats as $c): ?>
        <option value="<?=$c['id']?>"><?=$c['name']?></option>
      <?php endforeach; ?>
    </select>

    <label style="margin-top:6px">Название</label>
    <input class="input" name="name" required>

    <label style="margin-top:6px">Цена (₸)</label>
    <input class="input" name="price" type="number" required>

    <label style="margin-top:6px">Описание (кратко)</label>
    <textarea class="input" name="description" rows="2"></textarea>

    <label style="margin-top:6px">Состав</label>
    <textarea class="input" name="ingredients" rows="3"></textarea>

    <label style="margin-top:6px">Фото</label>
    <input class="input" type="file" name="image">

    <button class="btn btn-accent" style="margin-top:8px">Добавить</button>
  </form>
  <?php endif; ?>

  <h3 style="margin-top:14px">Список блюд</h3>
  <table class="table">
    <tr>
      <th>ID</th><th>Категория</th><th>Название</th><th>Цена</th><th>Статус</th><th>Действия</th>
    </tr>
    <?php foreach($foods as $f): ?>
    <tr>
      <td><?=$f['id']?></td>
      <td><?=$f['cat_name']?></td>
      <td><?=$f['name']?></td>
      <td><?=$f['price']?> ₸</td>
      <td><?=$f['is_available']? "Доступно":"СТОП"?></td>
      <td class="row">
        <form method="post" action="api/foods_crud.php">
          <input type="hidden" name="action" value="toggle">
          <input type="hidden" name="id" value="<?=$f['id']?>">
          <button class="btn btn-ghost" type="submit"><?=$f['is_available']? "На стоп":"В продажу"?></button>
        </form>
        <?php if($role==='owner'): ?>
          <form method="post" action="api/foods_crud.php" onsubmit="return confirm('Удалить?')">
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="id" value="<?=$f['id']?>">
            <button class="btn btn-danger" type="submit">Удалить</button>
          </form>
        <?php endif; ?>
      </td>
    </tr>
    <?php endforeach; ?>
  </table>
</div>
</body>
</html>
