<?php
require_once __DIR__."/../config/db.php";
require_once __DIR__."/../config/auth.php";
require_login();
$role=$_SESSION['user']['role'];
?>
<!doctype html>
<html lang="ru">
<head>
  <meta charset="utf-8">
  <title>Заказы • Triumph</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="container">
  <div class="header">
    <div class="logo">Triumph • Заказы</div>
    <div class="row">
      <?php if($role==='owner'): ?>
        <a class="btn btn-ghost" href="foods.php">Меню</a>
        <a class="btn btn-ghost" href="categories.php">Категории</a>
      <?php endif; ?>
      <a class="btn btn-ghost" href="logout.php">Выйти</a>
    </div>
  </div>

  <div class="tabs">
    <div class="tab active" data-status="NEW">Новые</div>
    <div class="tab" data-status="ACCEPTED">Принятые</div>
    <div class="tab" data-status="COOKING">Готовится</div>
    <div class="tab" data-status="READY">Готово</div>
    <div class="tab" data-status="DONE">Архив</div>
  </div>

  <div id="orders"></div>
</div>

<audio id="ding" src="data:audio/wav;base64,UklGRigAAABXQVZFZm10IBAAAAABAAEAESsAACJWAAACABAAZGF0YQgAAAAA////AAAA////AAAA////AAAA"></audio>

<script>
let active="NEW";
document.querySelectorAll(".tab").forEach(t=>{
  t.onclick=()=>{
    document.querySelectorAll(".tab").forEach(x=>x.classList.remove("active"));
    t.classList.add("active");
    active=t.dataset.status;
    render(lastData);
  };
});

let lastData=[], lastMaxId=0;

function render(data){
  const wrap=document.getElementById("orders");
  wrap.innerHTML="";
  data.filter(o=>o.status===active).forEach(o=>{
    const div=document.createElement("div");
    div.className="notice";
    div.innerHTML=`
      <div class="row">
        <div>
          <b>Заказ #${o.id}</b> • ПК <b>${o.pc_number}</b> (${o.hall_name||''})<br>
          <span class="muted">${o.created_at}</span>
        </div>
        <div class="space"></div>
        <span class="status-pill ${o.status}">${o.status_ru}</span>
      </div>
      <div style="margin-top:6px">
        ${o.items.map(i=>`${i.food_name} × ${i.quantity}`).join("<br>")}
      </div>
      <div class="row" style="margin-top:6px">
        <div>Итого: <b>${o.total} ₸</b></div>
        <div class="space"></div>
        ${buttons(o.status, o.id)}
      </div>
      ${o.comment ? `<div class="muted" style="margin-top:6px">Комментарий: ${o.comment}</div>` : ""}
    `;
    wrap.appendChild(div);
  });
}

function buttons(status,id){
  const role = <?=json_encode($role)?>;
  const can = (role==="kitchen" || role==="owner");
  if(!can) return "";
  let b="";
  if(status==="NEW") b+=`<button class="btn btn-ok" onclick="upd(${id},'ACCEPTED')">Принять</button>`;
  if(status==="ACCEPTED") b+=`<button class="btn btn-warn" onclick="upd(${id},'COOKING')">Готовится</button>`;
  if(status==="COOKING") b+=`<button class="btn btn-ok" onclick="upd(${id},'READY')">Готово</button>`;
  if(status==="READY") b+=`<button class="btn btn-ghost" onclick="upd(${id},'DONE')">Выдан</button>`;
  if(status!=="CANCELED" && status!=="DONE") b+=` <button class="btn btn-danger" onclick="upd(${id},'CANCELED')">Отменить</button>`;
  return b;
}

function upd(id,st){
  fetch("api/order_update.php",{
    method:"POST",
    headers:{"Content-Type":"application/json"},
    body:JSON.stringify({id, status:st})
  }).then(()=>poll());
}

function poll(){
  fetch("api/orders_poll.php")
    .then(r=>r.json())
    .then(d=>{
      if(!d.ok) return;
      lastData=d.orders;
      // звук на новый заказ
      const maxId = lastData.reduce((m,o)=>Math.max(m,o.id),0);
      if(maxId>lastMaxId){
        if(lastMaxId!==0) document.getElementById("ding").play();
        lastMaxId=maxId;
      }
      render(lastData);
    });
}
poll(); setInterval(poll,2000);
</script>
</body>
</html>
